DROP INDEX EESRV.SRVUSER_PK;

CREATE UNIQUE INDEX EESRV.SRVUSER_PK ON EESRV.SERVICE_USER
(SERVICE_USER_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.SRVUSER_FK_I;

CREATE INDEX EESRV.SRVUSER_FK_I ON EESRV.SERVICE_LOG
(SERVICE_USER_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.SRVUSERH_PK;

CREATE UNIQUE INDEX EESRV.SRVUSERH_PK ON EESRV.SERVICE_USER_H
(SERVICE_USER_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.SRVROL_PK;

CREATE UNIQUE INDEX EESRV.SRVROL_PK ON EESRV.SERVICE_REQUEST
(SERVICE_REQUEST_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.SRVROLH_PK;

CREATE UNIQUE INDEX EESRV.SRVROLH_PK ON EESRV.SERVICE_REQUEST_H
(SERVICE_REQUEST_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.SRVROLASS_PK;

CREATE UNIQUE INDEX EESRV.SRVROLASS_PK ON EESRV.SERVICE_REQUEST_ASSIGNMENT
(SERVICE_REQUEST_ASSIGNMENT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.SRVROLASSH_PK;

CREATE UNIQUE INDEX EESRV.SRVROLASSH_PK ON EESRV.SERVICE_REQUEST_ASSIGNMENT_H
(SERVICE_REQ_ASSIGN_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.SRVLOG_PK;

CREATE INDEX EESRV.SRVLOG_PK ON EESRV.SERVICE_LOG
(SERVICE_LOG_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.SERVICE_USER_USERNAME_UK;

CREATE UNIQUE INDEX EESRV.SERVICE_USER_USERNAME_UK ON EESRV.SERVICE_USER
(USERNAME)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.SERVICE_REQUEST_NAME_UK;

CREATE UNIQUE INDEX EESRV.SERVICE_REQUEST_NAME_UK ON EESRV.SERVICE_REQUEST
(NAME)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.ROLGRP_PK;

CREATE UNIQUE INDEX EESRV.ROLGRP_PK ON EESRV.REQUEST_GROUP
(REQUEST_GROUP_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.ROLGRPH_PK;

CREATE UNIQUE INDEX EESRV.ROLGRPH_PK ON EESRV.REQUEST_GROUP_H
(REQUEST_GROUP_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.ROLFLD_PK;

CREATE UNIQUE INDEX EESRV.ROLFLD_PK ON EESRV.REQUEST_FIELD
(REQUEST_FIELD_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.ROLFLD_H_PK;

CREATE UNIQUE INDEX EESRV.ROLFLD_H_PK ON EESRV.REQUEST_FIELD_H
(REQUEST_FIELD_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.IX_RELATIONSHIP9;

CREATE INDEX EESRV.IX_RELATIONSHIP9 ON EESRV.SERVICE_REQUEST_ASSIGNMENT
(SERVICE_USER_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.IX_RELATIONSHIP7;

CREATE INDEX EESRV.IX_RELATIONSHIP7 ON EESRV.REQUEST_FIELD
(FIELD_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.IX_RELATIONSHIP6;

CREATE INDEX EESRV.IX_RELATIONSHIP6 ON EESRV.REQUEST_FIELD
(SERVICE_REQUEST_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.IX_RELATIONSHIP17;

CREATE INDEX EESRV.IX_RELATIONSHIP17 ON EESRV.FIELD
(FIELD_GROUP_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.IX_RELATIONSHIP14;

CREATE INDEX EESRV.IX_RELATIONSHIP14 ON EESRV.REQUEST_GROUP
(FIELD_GROUP_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.IX_RELATIONSHIP13;

CREATE INDEX EESRV.IX_RELATIONSHIP13 ON EESRV.REQUEST_GROUP
(SERVICE_REQUEST_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.IX_RELATIONSHIP12;

CREATE INDEX EESRV.IX_RELATIONSHIP12 ON EESRV.FIELD_GROUP
(PARENT_GROUP_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.IX_RELATIONSHIP11;

CREATE INDEX EESRV.IX_RELATIONSHIP11 ON EESRV.SERVICE_REQUEST_ASSIGNMENT
(SERVICE_REQUEST_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.GRPH_PK;

CREATE UNIQUE INDEX EESRV.GRPH_PK ON EESRV.FIELD_GROUP_H
(FIELD_GROUP_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.FLD_PK;

CREATE UNIQUE INDEX EESRV.FLD_PK ON EESRV.FIELD
(FIELD_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.FLDH_PK;

CREATE UNIQUE INDEX EESRV.FLDH_PK ON EESRV.FIELD_H
(FIELD_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX EESRV.FLDGRP_PK;

CREATE UNIQUE INDEX EESRV.FLDGRP_PK ON EESRV.FIELD_GROUP
(FIELD_GROUP_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
